/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.awt.image.BufferedImage;

public class QrCode {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;

    public static BufferedImage createBarCodeImage(String data, String charset, int width, int height) throws WriterException {
        BitMatrix bitMatrix = new MultiFormatWriter().encode(data, BarcodeFormat.QR_CODE, width, height);
        BufferedImage qrImage = new BufferedImage(bitMatrix.getWidth(), bitMatrix.getHeight(), 12);
        qrImage.setRGB(0, 0, bitMatrix.getWidth(), bitMatrix.getHeight(), QrCode.toARGB(bitMatrix), 0, bitMatrix.getWidth());
        return qrImage;
    }

    private static int[] toARGB(BitMatrix matrix) {
        int[] result = new int[matrix.getWidth() * matrix.getHeight()];
        int i = 0;
        for (int x = 0; x < matrix.getWidth(); ++x) {
            for (int y = 0; y < matrix.getHeight(); ++y) {
                result[i++] = matrix.get(x, y) ? -16777216 : -1;
            }
        }
        return result;
    }
}

